<!--Please enable Word Wrap in Notepad to view this document.-->
# DXGL 0.5.18
https://dxgl.org

## Introduction
DXGL is a free replacement for the Windows ddraw.dll library, running on OpenGL. It is designed to overcome driver bugs, particularly in Windows Vista and newer operating systems. It also adds various enhancements to the graphics output such as display scaling and filtering options. DXGL supports the DirectX 7.0 graphics APIs, however it is currently under development and many programs are not yet compatible with DXGL.

## Updgrade notes
### DXGL 0.5.8
If you upgrade from DXGL 0.5.8 or earlier, the configuration format will be changed, and earlier versions of DXGL will no longer recognize the profiles. In addition, any profiles generated by older versions of DXGL going forward will not be recognized by DXGL 0.5.9 or later. If you wish to migrate any old profiles generated after installing DXGL 0.5.9 or later, you will need to use Regedit to delete the “Configuration Version” registry value from the HKEY_CURRENT_USER\SOFTWARE\DXGL registry key to force the upgrade to be run again.  In order to re-run the upgrade, re-run the DXGL installer.

### DXGL 0.5.13
DXGL 0.5.13 fixes up the default value for the “Add color depths” option, because version 0.5.12 and earlier had a default not compatible with current versions.  This one-time conversion resets the value for AddColorDepths in the registry entries to 1+4+16 which corresponds to enabling color depths 8-bit, 16-bit, and 32-bit, in order to ensure compatibility with Windows 8 and above.

The “Configuration Version” registry value in HKEY_CURRENT_USER\SOFTWARE\DXGL will be incremented to 2 in order to indicate this fix has been applied.

### DXGL 0.5.17
Due to a bug found in the method used to uniquely identify profile paths, DXGL 0.5.17 and above will perform a one-time renaming of the profile registry keys.  These new profiles will no longer be compatible with DXGL 0.5.16 or below.

The “Configuration Version” registry value in HKEY_CURRENT_USER\SOFTWARE\DXGL will be incremented to 3 in order to indicate this fix has been applied.  If you need to migrate more version 2 profiles, change “Configuration Version” to 2 and re-run the installer.

## System Requirements

* Windows Vista (with SP2), 7 (with SP1), 8, 8.1, or 10 (standard build)
* Windows XP (with SP3), Vista, 7, 8, 8.1, or 10 (legacy build)
  * Also compatible with most versions of Wine, by setting the ddraw DLL override to "native, builtin" which is done automatically at installation.
  * Not compatible with Windows 10 in S mode.
* OpenGL 2.0 or higher compatible video card
  * Requires support for Framebuffer objects
  * Requires support for hardware accelerated non-power-of-two textures
  * OpenGL 3.2 or higher recommended.
* The standard build requires a SSE2-capable processor; older processors require the legacy build.
* For the standard build, Visual C++ 2019 x86 runtime, available at https://aka.ms/vs/16/release/vc_redist.x86.exe (note this link may track visitors) (will be installed if not present)
* For the legacy build, Visual C++ 2010 x86 runtime, available at https://www.microsoft.com/en-us/download/details.aspx?id=8328 (will be installed if not present)

## Build Requirements
* For the legacy build, Visual Studio 2010 or Visual C++ 2010 Express Edition with Service Pack 1.
* For the standard build, Visual Studio 2019, Community or higher.
* The following components are optional.  The build process will ask for these if they do not exist:
  * TortoiseSVN (to fill in revision on SVN builds)
  * HTML Help Workshop (to build help)
  * NSIS (to build installer, requires TortoiseSVN and HTML Help Workshop to succeed)
* In addition Visual C++ 2005 and Visual C++ 2008 project files are available in the vs8 and vs9 directories respectively.

## Build Instructions
These instructions assume that you do not have any of the required software installed. If you already have any or all of this software installed and set up, skip those steps.

* Install Visual Studio 2019 Community at https://visualstudio.microsoft.com/
* Install Git for Windows at https://git-scm.com/download/win (should have already been installed to check out the repo)
* Install HTML Help Workshop from https://www.microsoft.com/en-us/download/details.aspx?id=21138
* Install NSIS from https://nsis.sourceforge.io/Main_Page
* Open the dxgl.sln file, select your build configuration (Debug or Release) in the toolbar, and press F7 to build.

## Debug tracing
The Debug Trace build has been removed from the project files for DXGL.  Instead, DXGL now supports debug tracing files in all builds.  To enable tracing in DXGL create a file named dxgl.cfg or dxgl.ini in you game folder and add the following to it:
```
[debug]
DebugTraceLevel=3
```
This can be added to the [debug] section of any existing configuration file.  Change back to 0 to disable tracing.

## Progress
For detailed progress information, please check https://www.williamfeely.info/wiki/DXGL_Features
What works:

* DirectDraw object creation and destruction (versions 1 to 7)
* Display mode enumeration and switching (with emulated mode switching)
* Fullscreen and windowed modes.
* Basic Blt() functionality
* 8-bit color emulated with GLSL shader
* Packed-pixel YUV surfaces (currently only supported by Blt() to an RGB surface)

What partially works:

* 3D graphics are only partially supported.
* Overlay support is currently in development and has limited functionality.

What doesn't work:

* Many functions are stubbed out and return an error

## Installation

Run the installer.  When the installer completes, open DXGL Config and add your program files to the config program.
To uninstall, go to the Add/Remove Programs or Programs and Features control panel and uninstall.

## GitHub

Source code for DXGL is available at https://github.com/dxgldotorg/dxgl

## AppDB

An AppDB system (similar to that on winehq.org) is now available at:
https://dxgl.org/appdb/

This requires a user account separate from the other services.

Please note that the AppDB is now deprecated and will be made read-only once the new DXGL Wiki launches.

## Discussion boards

You may discuss DXGL at:
https://forum.dxgl.info

You must create a forum account to post content.  For bug reports, please refer to the next section.

## Bug reports

Please report bugs via the GitHub Issues system:
https://github.com/dxgldotorg/dxgl/issues
A GitHub account is required to file issues.
