/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the mingw-w64 runtime package.
 * No warranty is given; refer to the file DISCLAIMER.PD within the mingw-w64 package.
 */
#pragma once
#ifndef _MINGW_SETDISPLAYCONFIG
#define _MINGW_SETDISPLAYCONFG

#define DISPLAYCONFIG_MAXPATH 1024

#ifdef __WIDL__
#  define __MINGW_EXTENSION
#else
#  if defined(__GNUC__) || defined(__GNUG__)
#    define __MINGW_EXTENSION __extension__
#  else
#    define __MINGW_EXTENSION
#  endif
#endif /* __WIDL__ */

#define __C89_NAMELESS __MINGW_EXTENSION

typedef BOOL WINBOOL;

typedef struct DISPLAYCONFIG_RATIONAL {
	UINT32 Numerator;
	UINT32 Denominator;
} DISPLAYCONFIG_RATIONAL;

typedef enum {
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_OTHER = (int)-1,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_HD15 = (int)0,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SVIDEO = (int)1,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_COMPOSITE_VIDEO = (int)2,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_COMPONENT_VIDEO = (int)3,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DVI = (int)4,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_HDMI = (int)5,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_LVDS = (int)6,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_D_JPN = (int)8,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SDI = (int)9,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DISPLAYPORT_EXTERNAL = (int)10,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DISPLAYPORT_EMBEDDED = (int)11,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_UDI_EXTERNAL = (int)12,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_UDI_EMBEDDED = (int)13,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SDTVDONGLE = (int)14,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_INTERNAL = (int)0x80000000,
	DISPLAYCONFIG_OUTPUT_TECHNOLOGY_FORCE_UINT32 = (int)0xFFFFFFFF
} DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY;

typedef enum {
	DISPLAYCONFIG_SCANLINE_ORDERING_UNSPECIFIED = 0,
	DISPLAYCONFIG_SCANLINE_ORDERING_PROGRESSIVE = 1,
	DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED = 2,
	DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED_UPPERFIELDFIRST = 2,
	DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED_LOWERFIELDFIRST = 3,
	DISPLAYCONFIG_SCANLINE_ORDERING_FORCE_UINT32 = 0xFFFFFFFF
} DISPLAYCONFIG_SCANLINE_ORDERING;

typedef struct DISPLAYCONFIG_2DREGION {
	UINT32 cx;
	UINT32 cy;
} DISPLAYCONFIG_2DREGION;

typedef struct DISPLAYCONFIG_VIDEO_SIGNAL_INFO {
	UINT64 pixelRate;
	DISPLAYCONFIG_RATIONAL hSyncFreq;
	DISPLAYCONFIG_RATIONAL vSyncFreq;
	DISPLAYCONFIG_2DREGION activeSize;
	DISPLAYCONFIG_2DREGION totalSize;
	UINT32 videoStandard;
	DISPLAYCONFIG_SCANLINE_ORDERING scanLineOrdering;
} DISPLAYCONFIG_VIDEO_SIGNAL_INFO;

typedef enum {
	DISPLAYCONFIG_SCALING_IDENTITY = 1,
	DISPLAYCONFIG_SCALING_CENTERED = 2,
	DISPLAYCONFIG_SCALING_STRETCHED = 3,
	DISPLAYCONFIG_SCALING_ASPECTRATIOCENTEREDMAX = 4,
	DISPLAYCONFIG_SCALING_CUSTOM = 5,
	DISPLAYCONFIG_SCALING_PREFERRED = 128,
	DISPLAYCONFIG_SCALING_FORCE_UINT32 = 0xFFFFFFFF
} DISPLAYCONFIG_SCALING;

typedef enum {
	DISPLAYCONFIG_ROTATION_IDENTITY = 1,
	DISPLAYCONFIG_ROTATION_ROTATE90 = 2,
	DISPLAYCONFIG_ROTATION_ROTATE180 = 3,
	DISPLAYCONFIG_ROTATION_ROTATE270 = 4,
	DISPLAYCONFIG_ROTATION_FORCE_UINT32 = 0xFFFFFFFF
} DISPLAYCONFIG_ROTATION;

typedef enum {
	DISPLAYCONFIG_MODE_INFO_TYPE_SOURCE = 1,
	DISPLAYCONFIG_MODE_INFO_TYPE_TARGET = 2,
	DISPLAYCONFIG_MODE_INFO_TYPE_FORCE_UINT32 = 0xFFFFFFFF
} DISPLAYCONFIG_MODE_INFO_TYPE;

typedef enum {
	DISPLAYCONFIG_PIXELFORMAT_8BPP = 1,
	DISPLAYCONFIG_PIXELFORMAT_16BPP = 2,
	DISPLAYCONFIG_PIXELFORMAT_24BPP = 3,
	DISPLAYCONFIG_PIXELFORMAT_32BPP = 4,
	DISPLAYCONFIG_PIXELFORMAT_NONGDI = 5,
	DISPLAYCONFIG_PIXELFORMAT_FORCE_UINT32 = 0xffffffff
} DISPLAYCONFIG_PIXELFORMAT;

typedef struct DISPLAYCONFIG_SOURCE_MODE {
	UINT32 width;
	UINT32 height;
	DISPLAYCONFIG_PIXELFORMAT pixelFormat;
	POINTL position;
} DISPLAYCONFIG_SOURCE_MODE;

typedef struct DISPLAYCONFIG_TARGET_MODE {
	DISPLAYCONFIG_VIDEO_SIGNAL_INFO   targetVideoSignalInfo;
} DISPLAYCONFIG_TARGET_MODE;

typedef struct DISPLAYCONFIG_MODE_INFO {
	DISPLAYCONFIG_MODE_INFO_TYPE infoType;
	UINT32 id;
	LUID adapterId;
	__C89_NAMELESS union {
		DISPLAYCONFIG_TARGET_MODE targetMode;
		DISPLAYCONFIG_SOURCE_MODE sourceMode;
	};
} DISPLAYCONFIG_MODE_INFO;

#define DISPLAYCONFIG_PATH_MODE_IDX_INVALID 0xffffffff

typedef struct DISPLAYCONFIG_PATH_SOURCE_INFO {
	LUID adapterId;
	UINT32 id;
	UINT32 modeInfoIdx;
	UINT32 statusFlags;
} DISPLAYCONFIG_PATH_SOURCE_INFO;

#define DISPLAYCONFIG_SOURCE_IN_USE 0x1

typedef struct DISPLAYCONFIG_PATH_TARGET_INFO {
	LUID adapterId;
	UINT32 id;
	UINT32 modeInfoIdx;
	DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY outputTechnology;
	DISPLAYCONFIG_ROTATION rotation;
	DISPLAYCONFIG_SCALING scaling;
	DISPLAYCONFIG_RATIONAL refreshRate;
	DISPLAYCONFIG_SCANLINE_ORDERING scanLineOrdering;
	WINBOOL targetAvailable;
	UINT32 statusFlags;
} DISPLAYCONFIG_PATH_TARGET_INFO;

#define DISPLAYCONFIG_TARGET_IN_USE 0x00000001
#define DISPLAYCONFIG_TARGET_FORCIBLE 0x00000002
#define DISPLAYCONFIG_TARGET_FORCED_AVAILABILITY_BOOT 0x00000004
#define DISPLAYCONFIG_TARGET_FORCED_AVAILABILITY_PATH 0x00000008
#define DISPLAYCONFIG_TARGET_FORCED_AVAILABILITY_SYSTEM  0x00000010

typedef struct DISPLAYCONFIG_PATH_INFO {
	DISPLAYCONFIG_PATH_SOURCE_INFO sourceInfo;
	DISPLAYCONFIG_PATH_TARGET_INFO targetInfo;
	UINT32 flags;
} DISPLAYCONFIG_PATH_INFO;

#define DISPLAYCONFIG_PATH_ACTIVE 0x1

typedef enum {
	DISPLAYCONFIG_TOPOLOGY_INTERNAL = 0x1,
	DISPLAYCONFIG_TOPOLOGY_CLONE = 0x2,
	DISPLAYCONFIG_TOPOLOGY_EXTEND = 0x4,
	DISPLAYCONFIG_TOPOLOGY_EXTERNAL = 0x8,
	DISPLAYCONFIG_TOPOLOGY_FORCE_UINT32 = 0xFFFFFFFF
} DISPLAYCONFIG_TOPOLOGY_ID;

typedef enum {
	DISPLAYCONFIG_DEVICE_INFO_GET_SOURCE_NAME = 1,
	DISPLAYCONFIG_DEVICE_INFO_GET_TARGET_NAME = 2,
	DISPLAYCONFIG_DEVICE_INFO_GET_TARGET_PREFERRED_MODE = 3,
	DISPLAYCONFIG_DEVICE_INFO_GET_ADAPTER_NAME = 4,
	DISPLAYCONFIG_DEVICE_INFO_SET_TARGET_PERSISTENCE = 5,
	DISPLAYCONFIG_DEVICE_INFO_FORCE_UINT32 = 0xFFFFFFFF
} DISPLAYCONFIG_DEVICE_INFO_TYPE;

typedef struct DISPLAYCONFIG_DEVICE_INFO_HEADER {
	DISPLAYCONFIG_DEVICE_INFO_TYPE type;
	UINT32 size;
	LUID adapterId;
	UINT32 id;
} DISPLAYCONFIG_DEVICE_INFO_HEADER;

typedef struct DISPLAYCONFIG_SOURCE_DEVICE_NAME {
	DISPLAYCONFIG_DEVICE_INFO_HEADER header;
	WCHAR viewGdiDeviceName[CCHDEVICENAME];
} DISPLAYCONFIG_SOURCE_DEVICE_NAME;

typedef struct DISPLAYCONFIG_TARGET_DEVICE_NAME_FLAGS {
	__C89_NAMELESS union {
		__C89_NAMELESS struct {
			UINT32 friendlyNameFromEdid : 1;
			UINT32 friendlyNameForced : 1;
			UINT32 edidIdsValid : 1;
			UINT32 reserved : 29;
		};
		UINT32 value;
	};
} DISPLAYCONFIG_TARGET_DEVICE_NAME_FLAGS;

typedef struct DISPLAYCONFIG_TARGET_DEVICE_NAME {
	DISPLAYCONFIG_DEVICE_INFO_HEADER header;
	DISPLAYCONFIG_TARGET_DEVICE_NAME_FLAGS flags;
	DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY outputTechnology;
	UINT16 edidManufactureId;
	UINT16 edidProductCodeId;
	UINT32 connectorInstance;
	WCHAR monitorFriendlyDeviceName[64];
	WCHAR monitorDevicePath[128];
} DISPLAYCONFIG_TARGET_DEVICE_NAME;

typedef struct DISPLAYCONFIG_TARGET_PREFERRED_MODE {
	DISPLAYCONFIG_DEVICE_INFO_HEADER header;
	UINT32 width;
	UINT32 height;
	DISPLAYCONFIG_TARGET_MODE targetMode;
} DISPLAYCONFIG_TARGET_PREFERRED_MODE;

typedef struct DISPLAYCONFIG_ADAPTER_NAME {
	DISPLAYCONFIG_DEVICE_INFO_HEADER header;
	WCHAR adapterDevicePath[128];
} DISPLAYCONFIG_ADAPTER_NAME;

typedef struct DISPLAYCONFIG_SET_TARGET_PERSISTENCE {
	DISPLAYCONFIG_DEVICE_INFO_HEADER header;
	__C89_NAMELESS union {
		__C89_NAMELESS struct {
			UINT32 bootPersistenceOn : 1;
			UINT32 reserved : 31;
		};
		UINT32 value;
	};
} DISPLAYCONFIG_SET_TARGET_PERSISTENCE;

#define QDC_ALL_PATHS 0x00000001
#define QDC_ONLY_ACTIVE_PATHS 0x00000002
#define QDC_DATABASE_CURRENT 0x00000004

#define SDC_TOPOLOGY_INTERNAL 0x00000001
#define SDC_TOPOLOGY_CLONE 0x00000002
#define SDC_TOPOLOGY_EXTEND 0x00000004
#define SDC_TOPOLOGY_EXTERNAL 0x00000008
#define SDC_TOPOLOGY_SUPPLIED 0x00000010
#define SDC_USE_DATABASE_CURRENT (SDC_TOPOLOGY_INTERNAL | SDC_TOPOLOGY_CLONE \
  | SDC_TOPOLOGY_EXTEND | SDC_TOPOLOGY_EXTERNAL)

#define SDC_USE_SUPPLIED_DISPLAY_CONFIG 0x00000020
#define SDC_VALIDATE                    0x00000040
#define SDC_APPLY                       0x00000080
#define SDC_NO_OPTIMIZATION             0x00000100
#define SDC_SAVE_TO_DATABASE            0x00000200
#define SDC_ALLOW_CHANGES               0x00000400
#define SDC_PATH_PERSIST_IF_REQUIRED    0x00000800
#define SDC_FORCE_MODE_ENUMERATION      0x00001000
#define SDC_ALLOW_PATH_ORDER_CHANGES    0x00002000

#endif //_MINGW_SETDISPLAYCONFIG